<?php

namespace Move\Advertiser\Google\DfpSmallBusiness;

/**
 * Class SizeMapping
 * @package Move\Advertiser\Google\DfpSmallBusiness
 */
class SizeMapping
{

    /** @var array */
    public $adSizeCollection;

    /** @var null|string */
    public $name;

    /** @var \Move\Advertiser\Google\DfpSmallBusiness\Size[] */
    protected $uniqSizes;

    /**
     * SizeMapping constructor.
     * @param string|null $name
     * @param array $defaultSizes
     */
    public function __construct(string $name = null, array $defaultSizes = [])
    {
        $this->name = $name;
        $this->adSizeCollection = [];
        $this->uniqSizes = [];
        if (!empty($defaultSizes)) {
            $this->appendAdSize(new Size(), $defaultSizes);
        }
    }

    /**
     * @param \Move\Advertiser\Google\DfpSmallBusiness\Size $navigatorSize
     * @param \Move\Advertiser\Google\DfpSmallBusiness\Size[] $adSizes
     * @return $this
     */
    public function appendAdSize(Size $navigatorSize, array $adSizes) : self
    {
        $this->adSizeCollection[] = [$navigatorSize, $adSizes];
        foreach ($adSizes as $size) {
            $this->uniqSizes[$size->width . $size->height] = $size;
        }
        return $this;
    }

    /**
     * @return \Move\Advertiser\Google\DfpSmallBusiness\Size[]
     */
    public function getUniqSizes() : array
    {
        krsort($this->uniqSizes);
        return array_values($this->uniqSizes);
    }
}
