<?php

namespace Move\Http\Route;

use League\Container\ContainerInterface;

/**
 * Class AbstractRouterAdapter
 * @package Move\Http\Route
 */
abstract class AbstractRouterAdapter implements RouterAdapterInterface
{

    /**
     * Lance la creation de route via les provider de route
     * @param string[]|AbstractRouteProvider[] $providers
     * @param ContainerInterface $container
     * @throws \Psr\Container\ContainerExceptionInterface
     * @throws \Psr\Container\NotFoundExceptionInterface
     */
    public function delegate(array $providers, ContainerInterface $container = null)
    {
        foreach ($providers as $provider) {
            if (is_scalar($provider)) {
                // si class invalide
                if (!class_exists($provider)
                    || !\in_array(AbstractRouteProvider::class, class_parents($provider), true)
                ) {
                    throw new \InvalidArgumentException("Provider $provider does not exist");
                }
                // creation de l'instance de provider
                if (!empty($container) && $container->has($provider)) {
                    $providerObject = $container->get($provider);
                } else {
                    $providerObject = new $provider();
                }
            } else {
                $providerObject = $provider;
            }
            // check si objet ok
            if ($providerObject instanceof AbstractRouteProvider) {
                if (!empty($container)) {
                    $providerObject->setContainer($container);
                }
                // register les route
                $providerObject->setRouterAdapter($this)->register();
            }
        }
    }
}
