<?php


namespace Move\Image\Tools;

/**
 * Class JpegOptim
 * @package Move\Image\Tools
 */
class JpegOptim
{
    /** @var  string */
    private $binaryPath;

    /**
     * JpegOptim constructor.
     * @param string $binaryPath
     */
    public function __construct($binaryPath = '/usr/bin/jpegoptim')
    {
        $this->binaryPath = $binaryPath;
    }

    /**
     * @param string $imagePath
     * @return $this
     * @throws \RuntimeException
     */
    public function optimise($imagePath)
    {
        exec(
            $this->binaryPath . ' --all-progressive -o --preserve --max=90 --strip-all ' . $imagePath,
            $outputs,
            $resultVar
        );
        if ($resultVar != 0) {
            throw new \RuntimeException('JPEGOPTIM was unable to optimise image, result:' . $resultVar . ' File: ' . $imagePath);
        }
        return $this;
    }
}
