<?php


namespace Move\Search;

use Elastica\Index;
use Elastica\Type\Mapping;
use Move\Search\Mapping\ElasticMappingProperty;

/**
 * Interface MappingBuilderInterface
 * @package Move\Search
 */
interface ElasticMappingBuilderInterface
{

    /**
     * @param \Elastica\Index $index
     * @param string $typeName
     * @param bool $recreate
     * @return \Elastica\Type\Mapping
     */
    public function createMapping(
        Index $index,
        string $typeName = null,
        bool $recreate = false
    ) : Mapping;

    /**
     * @param string $typeName
     * @return $this
     */
    public function setTypeName(string $typeName);

    /**
     * @param \Move\Search\Mapping\ElasticMappingProperty $property
     * @return $this
     */
    public function setProperty(ElasticMappingProperty $property);

    /**
     * @return array
     */
    public function getPropertyNames() : array;
}
