<?php

namespace Cms\Bundle\Member;

use Cms\Client\Member\MemberClient;
use Cms\Client\Member\Transformer\MemberTransformer;
use Cms\Client\Service\MemberProvider;
use League\Container\Argument\RawArgument;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class MemberLoginProvider
 * @package Cms\Bundle\Member
 */
class MemberLoginProvider extends AbstractServiceProvider implements
    BootableServiceProviderInterface
{

    /** @var  int */
    protected $scopeId;

    /** @var array */
    protected $provides = [
        MemberLoginService::class,
    ];

    /**
     * MemberLoginProvider constructor.
     * @param int $scopeId
     */
    public function __construct(int $scopeId)
    {
        $this->scopeId = $scopeId;
    }

    /**
     * Use the register method to register items with the container via the
     * protected $this->container property or the `getContainer` method
     * from the ContainerAwareTrait.
     * @return void
     */
    public function register()
    {
        $this->container->add(MemberLoginService::class)
            ->withArguments([
                new RawArgument($this->scopeId),
                MemberClient::class,
                MemberTransformer::class,
            ]);
    }


    /**
     * Method will be invoked on registration of a service provider implementing
     * this interface. Provides ability for eager loading of Service Providers.
     * @return void
     */
    public function boot()
    {
        $this->container->addServiceProvider(new MemberProvider());
    }
}
