<?php

namespace Cms\LinkResource;

use POM\DomainObjectAbstract;

/**
 * Class LinkResourceModel
 * @package Cms\LinkResource
 * @property int $id
 * @property string $link_provider
 * @property string $link_ref
 * @property LinkResourceType $link_type
 * @property LinkResourcePrefsModel $link_prefs
 */
class LinkResourceModel extends DomainObjectAbstract
{

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $link_provider;

    /** @var  string */
    protected $link_ref;

    /** @var  LinkResourceType */
    protected $link_type;

    /** @var  LinkResourcePrefsModel */
    protected $link_prefs;

    /**
     * @return string
     */
    public function toUrn() : string
    {
        return 'urn:move:'
            . $this->link_provider
            . ':' . $this->link_type
            . ':' . $this->link_ref;
    }
}
