<?php

namespace Cms\Model\Contract\Product;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EmptySpecification;
use Move\Specification\EnumSpecification;

/**
 * Class ProductValidator
 * @package Cms\Model\Contract\Product
 */
class ProductValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter() : Filter
    {
        // filtre du model
        $myFilter = new Filter([
            'profil' => (new EmptySpecification())->orSpec(
                new EnumSpecification(ProductProfile::class)
            ),
        ]);
        return $myFilter;
    }
}
