<?php


namespace Cms\Model\Member;

use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class MemberRewardModel
 * @package Cms\Model\Member
 * @property int $id
 * @property int $member_id
 * @property string $source
 * @property string $campaign
 * @property int $total_use
 * @property \DateTime $first_use_at
 * @property \Cms\Model\Member\MemberRewardState $state
 */
class MemberRewardModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;

    /** @var int */
    protected $id;

    /** @var int */
    protected $member_id;

    /** @var string */
    protected $source;

    /** @var string */
    protected $campaign;

    /** @var int */
    protected $total_use;

    /** @var \DateTime */
    protected $first_use_at;

    /** @var MemberRewardState */
    protected $state;
}
