<?php


namespace Cms\Utils;

use Cms\Model\Asset\Config\ConfigImageModel;
use Cms\Route\AssetProxyRoute;
use Move\Http\Route\RouterAdapterInterface;
use Move\Image\ImageUtils;

/**
 * Class AssetUtils
 * @package Cms\Utils
 */
class AssetUtils
{

    /**
     * @param RouterAdapterInterface $router
     * @param string $prefix
     * @param string $handler
     * @return mixed
     */
    public static function assignRouteList(RouterAdapterInterface $router, $prefix, $handler)
    {
        return $router->group($prefix, self::getRouteList($handler));
    }

    /**
     * @param string $handler
     * @return array
     */
    public static function getRouteList($handler) : array
    {
        return [
            [
                'method' => 'GET',
                'path' => AssetProxyRoute::getStdPath(true, true),
                'handler' => $handler,
            ],
            [
                'method' => 'GET',
                'path' => AssetProxyRoute::getStdPath(false, true),
                'handler' => $handler,
            ],
            [
                'method' => 'GET',
                'path' => AssetProxyRoute::getStdPath(true),
                'handler' => $handler,
            ],
            [
                'method' => 'GET',
                'path' => AssetProxyRoute::getStdPath(),
                'handler' => $handler,
            ],
            [
                'method' => 'GET',
                'path' => AssetProxyRoute::getPhPath(),
                'handler' => $handler,
            ],
        ];
    }

    /**
     * @param resource $img
     * @param ConfigImageModel $configModel
     * @param array $size
     * @return resource
     * @throws \InvalidArgumentException
     */
    public static function scaleImageWithConfig(
        $img,
        ConfigImageModel $configModel,
        array $size = []
    ) {
        if (get_resource_type($img) !== 'gd') {
            throw new \InvalidArgumentException('img must be a gd resource');
        }

        // calcul des nouvelle largeur/hauteur
        $scale = $configModel->scale ?: 1;
        $imgWidth = $scale * imagesx($img);
        $imgHeight = $scale * imagesy($img);
        if ($scale !== 1) {
            // scaling
            $imgCopy = ImageUtils::scaleImage($img, $imgWidth, $imgHeight);
        } else {
            $imgCopy = $img;
        }

        // calcul du point d'interet de l'image a partir de la config ou en centrant
        if (empty($configModel->focus_x) && empty($configModel->focus_y)) {
            $focusX = $imgWidth / 2;
            $focusY = $imgHeight / 2;
        } else {
            $focusX = ($configModel->focus_x ?: 0) * $scale;
            $focusY = ($configModel->focus_y ?: 0) * $scale;
        }

        // focus et scale
        $imgFocus = ImageUtils::scaleImageWithFocus($imgCopy, $focusX, $focusY, $size);
        return $imgFocus;
    }
}
