<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedModel;

/**
 * Class GenericIframe
 * @package Move\Embed\Adapter
 */
class GenericIframe implements AdapterInterface
{

    /**
     * Renvoi les données de la source sous forme de model
     * @param string $sourceUri
     * @param array $params
     * @return EmbedModel|null
     * @throws \ReflectionException
     */
    public function getEmbedModel($sourceUri, array $params = [])
    {
        $iframe = '<iframe src="' . $sourceUri . '" frameborder="0" style="border:0"></iframe>';
        return new EmbedModel([
            'title' => '',
            'provider_name' => 'Generic Iframe',
            'provider_url' => 'https://cms.regiecamp.com',
            'author_name' => 'RegieCamp',
            'html' => $iframe,
            'thumbnail_url' => null,
            'canonical_url' => $sourceUri,
            'source_url' => $sourceUri,
        ]);
    }
}
