<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedModel;
use Move\Embed\Parser\ParserInterface;

/**
 * Class Oembed
 * @package Embed\Adapter
 */
class OembedFacebook extends Oembed
{

    /** @var ParserInterface */
    private $parser;

    /**
     * OembedFacebook constructor.
     * @param string $endpoint
     * @param array $defaultParams
     * @param ParserInterface $parser
     */
    public function __construct($endpoint, array $defaultParams, ParserInterface $parser)
    {
        parent::__construct($endpoint, $defaultParams);
        $this->parser = $parser;
    }

    /**
     * Renvoi les données de la source sous forme de model
     * @param string $sourceUri
     * @param array $params
     * @return EmbedModel
     */
    public function getEmbedModel($sourceUri, array $params = [])
    {
        $embedModel = parent::getEmbedModel($sourceUri, $params);
        $sourceUrl = $embedModel->source_url = 'https://www.facebook.com/plugins/video.php?href='
            . urlencode($embedModel->source_url)
            . '&height=' . ($height = $embedModel->provider_data['height'])
            . '&width=' . ($width = $embedModel->provider_data['width']);
        $embedModel->title = strip_tags($embedModel->html);

        // ajoute le thumb
        $this->parser->matchString($sourceUri, $uriParams);
        if (!empty($uriParams[1]) && is_numeric($uriParams[1])) {
            $embedModel->thumbnail_url = 'https://graph.facebook.com/' . $uriParams[1] . '/picture';
            $embedModel->thumbnail_height = $height;
            $embedModel->thumbnail_width = $width;
        }
        // ajoute le code iframe
        $embedModel->html = <<<EOF
<iframe src="$sourceUrl&appId" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true"></iframe>
EOF;
        return $embedModel;
    }
}
