<?php


namespace Move\Newsletter\Provider;

/**
 * Class MailjetCryptHelper
 * @package Move\Newsletter\Provider
 */
class MailjetCryptHelper
{

    /**
     * Fonctions d'encrytage et décyptage pour la QS a passer dans les mail de confirmation d'Optin
     * encrypt(),decrypt(),safeB64encode(),safeB64decode()
     * source :
     * https:\/\/stackoverflow.com\/questions\/12102670\/php-form-example-which-will-encrypt-query-string-get-data-hiding-rather-tha
     * @param string $salt
     * @param string|null $value
     * @return bool|mixed|string
     */
    public static function encrypt(string $salt, string $value = null)
    {
        if (!$value) {
            return false;
        }
        $iv_size = openssl_cipher_iv_length('aes-256-cbc');
        $iv = openssl_random_pseudo_bytes($iv_size);
        $crypttext = openssl_encrypt($value, 'aes-256-cbc', $salt, OPENSSL_RAW_DATA, $iv);
        return self::safeB64encode($iv . $crypttext);
    }

    /**
     * @param string $salt
     * @param string|null $value
     * @return bool|string
     */
    public static function decrypt(string $salt, string $value = null)
    {
        if (!$value) {
            return false;
        }
        $crypttext = self::safeB64decode($value);
        $iv_size = openssl_cipher_iv_length('aes-256-cbc');
        $iv = substr($crypttext, 0, $iv_size);
        $crypttext = substr($crypttext, $iv_size);
        if (!$crypttext) {
            return false;
        }
        $decrypttext = openssl_decrypt($crypttext, 'aes-256-cbc', $salt, OPENSSL_RAW_DATA, $iv);
        return rtrim($decrypttext);
    }

    /**
     * @param string $string
     * @return bool|string
     */
    private static function safeB64decode($string = '')
    {
        $data = str_replace(['-', '_'], ['+', '/'], $string);
        $mod4 = \strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }

    /**
     * @param string $string
     * @return mixed|string
     */
    private static function safeB64encode($string = '')
    {
        $data = base64_encode($string);
        $data = str_replace(['+', '/', '='], ['-', '_', ''], $data);
        return $data;
    }
}
