<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\GroupRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class CampsiteClient
 * @package Cms\Client\Campsite
 */
class GroupClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite/group';

    /**
     * @param array $dataset
     * @return GroupRestfulModel
     */
    public function handleData($dataset = []) : Model\GroupRestfulModel
    {
        return (new GroupRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|\Cms\Client\Campsite\Model\GroupRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $scopeId
     * @param string $search
     * @param string|null $type
     * @param int $pageNum
     * @return \Cms\Client\Campsite\Model\GroupRestfulModel[]|\Cms\Client\CmsApiIndexIterator
     */
    public function getIndexBySearch(
        int $scopeId,
        string $search = null,
        string $type = null,
        int $pageNum = 0
    ) : CmsApiIndexIterator {
        return $this->getBuilder()
            ->setFilter('scope_id', $scopeId)
            ->setFilter('type', $type)
            ->setFilter('search', $search)
            ->getIndex($pageNum);
    }
}
