<?php


namespace Cms\Extension;

use Cms\Client\AssetConfigRelationRestfulModel;
use Cms\Extension\MediaHandler\MediaHandlerInterface;
use Cms\Extension\MediaHandler\MediaHandlerRequest;
use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class MediaHandlerExtension
 * @package Cms\Extension
 */
class MediaHandlerExtension implements ExtensionInterface
{

    /** @var MediaHandlerInterface */
    private $handler;

    /**
     * MediaHandlerExtension constructor.
     * @param MediaHandlerInterface $assetHandler
     */
    public function __construct(MediaHandlerInterface $assetHandler)
    {
        $this->handler = $assetHandler;
    }

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('media', [$this, 'handleMedia']);
    }

    /**
     * @param int|array $assetData
     * @param array $handlerConfig
     * @return void
     */
    public function handleMedia($assetData, array $handlerConfig = [])
    {
        // check du tableau de données
        if (!\is_array($assetData)) {
            trigger_error('assetData is not an array', E_USER_WARNING);
            return null;
        }

        // chargement de l'objet relation
        $model = new AssetConfigRelationRestfulModel();
        $model->populate($assetData);
        if (!$model->asset_id || !$model->asset_config_id) {
            trigger_error('asset relation is invalid', E_USER_WARNING);
            return null;
        }

        // récuperation
        $request = new MediaHandlerRequest($model, $handlerConfig);
        $response = $this->handler->handle($request);
        echo $response;
    }
}
