<?php


namespace Cms\Extension;

use Cms\Extension\TemplateBloc\AbstractBlocHandler;
use Cms\Extension\TemplateBloc\BlocHandlerRequest;
use Cms\Extension\TemplateBloc\BlocHandlerResponse;
use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class TemplateBlocsExtenstion
 * @package AutoMag\Extension
 */
class TemplateBlocsExtension implements ExtensionInterface
{

    /** @var  AbstractBlocHandler */
    protected $blocHandler;

    /** @var  Engine */
    private $engine;

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('insert_bloc', [$this, 'insertBloc']);
        $this->engine = $engine;
    }

    /**
     * @param AbstractBlocHandler $blocHandler
     * @return $this
     */
    public function setBlocHandler(AbstractBlocHandler $blocHandler)
    {
        $this->blocHandler = $blocHandler;
        return $this;
    }

    /**
     * @param mixed $blocModel
     * @param array $data
     * @return void
     * @throws \Throwable
     * @throws \Exception
     */
    public function insertBloc($blocModel, array $data = [])
    {
        if (!$this->engine || !$blocModel instanceof TemplateBlocRestfulModel) {
            return null;
        }

        // récuperation des donnée du template
        $request = new BlocHandlerRequest($blocModel);
        $blocResponse = $this->blocHandler->handle($request);

        // rendu de la réponse
        if (\is_string($blocResponse)) {
            echo $blocResponse;
        } elseif ($blocResponse instanceof BlocHandlerResponse) {
            if ($blocResponse->getTemplatePath()) {
                $templatePath = $blocResponse->getTemplatePath();

                // ajoute les donnée de template
                if (!empty($data[$templatePath])) {
                    $this->engine->addData($data[$templatePath], $templatePath);
                }

                $template = $this->engine->make($templatePath);
                echo $template->render($blocResponse->getContentData());
            }
        }
        echo '<!--# bloc_id:' . $blocModel->id . '/' . $blocModel->type . '/' . $blocModel->show_profil . ' #-->';
    }
}
