<?php


namespace Cms\Model\Article;

use Cms\DashParser\DashContentInterface;
use POM\DomainObjectAbstract;

/**
 * Class ArticleContent
 * @package Cms\Model\Article
 * @property array $blocks
 * @property array $entityMap
 * @property string $html
 */
class ArticleContent extends DomainObjectAbstract implements
    \JsonSerializable,
    DashContentInterface
{

    /** @var  array */
    protected $blocks;

    /** @var  array */
    protected $entityMap;

    /** @var  string */
    protected $html;

    /**
     * @inheritdoc
     */
    public function jsonSerialize()
    {
        $dataset = $this->getArrayCopy();
        if (null === $dataset['entityMap']) {
            $dataset['entityMap'] = [];
        }
        if (null === $dataset['blocks']) {
            $dataset['blocks'] = [];
        }
        return $dataset;
    }

    /**
     * @return array
     */
    public function getBlocks()
    {
        return $this->blocks ?: [];
    }

    /**
     * @return array
     */
    public function getEntityMap()
    {
        return $this->entityMap ?: [];
    }
}
