<?php

namespace Cms\Model\Contract\Product;

use Cms\LinkResource\LinkResourceModel;
use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\StampAwareModelTrait;

/**
 * Class ProductConfigModel
 * @package Cms\Model\Contract\Product
 * @property int $product_id
 * @property \Cms\Model\Contract\Product\ProductConfigState $state
 * @property \DateTime $begin_at
 * @property \DateTime $end_at
 */
class ProductConfigModel extends LinkResourceModel
{
    use StampAwareModelTrait;
    use CmsUserIdAwareTrait;
    use ConfigAwareModelTrait;

    /** @var  int */
    protected $product_id;

    /** @var  \Cms\Model\Contract\Product\ProductConfigState */
    protected $state;

    /** @var  \DateTime */
    protected $begin_at;

    /** @var  \DateTime */
    protected $end_at;

    /** @var string */
    protected $extra = '';

    /**
     * @param string $offset
     * @return mixed
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function propertyGet($name)
    {
        if ($name === 'config') {
            return $this->getConfig();
        }
        if ($this->isExtraParameter($name)) {
            return $this->getExtraParameter($name);
        }

        return parent::propertyGet($name);
    }

    /**
     * @param string $name
     * @param mixed $value
     */
    public function propertySet($name, $value)
    {
        if (!$this->propertyExists($name)) {
            $aExtra = json_decode($this->extra, true);
            $aExtra[$name] = $value;
            $this->extra = json_encode($aExtra);
            $name = 'extra';
            $value = $this->extra;
        }

        parent::propertySet($name, $value);
    }

    /**
     * @param string $name
     */
    public function propertyUnset($name)
    {
        if ($this->isExtraParameter($name)) {
            $this->unsetExtraParameter($name);
            parent::propertySet('extraParameters', $this->extra);

            return;
        }

        parent::propertyUnset($name);
    }

    /**
     * @param string $offset
     * @return bool
     */
    public function __isset($offset)
    {
        return $this->isExtraParameter($offset) || parent::__isset($offset);
    }

    /**
     * @param $name
     * @return bool
     */
    protected function isExtraParameter($name)
    {
        $aExtra = json_decode($this->extra, true);

        return in_array($name, array_keys($aExtra));
    }

    protected function getExtraParameter($name)
    {
        $aExtra = json_decode($this->extra, true);

        return $aExtra[$name];
    }

    protected function setExtraParameter($name, $value)
    {
        $aExtra = json_decode($this->extra, true);
        $aExtra[$name] = $value;

        $this->extra = json_encode($aExtra);
    }

    protected function unsetExtraParameter($name)
    {
        $aExtra = json_decode($this->extra, true);
        unset($aExtra[$name]);

        $this->extra = json_encode($aExtra);
    }
}
