<?php


namespace Move\Http\Strategy\Handler;

use Move\Http\RequestUtils;
use Move\Http\Strategy\ResponseFactory;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class HtmlHandlerService
 * @package Move\Http\Strategy\Handler
 */
class HtmlHandlerService extends HandlerServiceAbstract implements HandlerServiceInterface
{

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return \Psr\Http\Message\MessageInterface|\Psr\Http\Message\ResponseInterface
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function determineResponse($dataset, ResponseInterface $response)
    {
        if (!\is_string($dataset)) {
            if (!$dataset instanceof ResponseFactory) {
                $dataset = new ResponseFactory($dataset);
            }
            $response = $dataset->determineResponse($this->getSerializer(), $response);
        } else {
            if ($response->getBody()->isWritable()) {
                $response->getBody()->write($dataset);
            }
        }
        // ajout le header json a la reponse
        return $response->withHeader('Content-Type', 'text/html');
    }

    /**
     * @param ServerRequestInterface $request
     * @return bool
     */
    public function isSatisfiedBy($request) : bool
    {
        if (!$request instanceof ServerRequestInterface) {
            return false;
        }

        // check du type
        $mime = 'text/html';
        return RequestUtils::isAcceptable($request, $mime);
    }
}
