<?php

namespace Move\Template\Html\Asset;

use Move\Template\Html\RenderByTagStrategy;
use Move\Template\Html\RenderStrategyInterface;
use Move\Utils\TaggedItemCollection;

/**
 * Class Collection
 * @package Move\Template\Html\Asset
 */
class AssetCollection extends TaggedItemCollection
{

    /**
     * @var RenderStrategyInterface
     */
    private $strategy;

    /**
     * @param array $banishTags
     * @param RenderStrategyInterface|null $strategy
     */
    public function __construct(array $banishTags = [], RenderStrategyInterface $strategy = null)
    {
        parent::__construct($banishTags);
        $this->strategy = $strategy ?: new RenderByTagStrategy();
    }

    /**
     * Ajoute d'une liste d'asset
     * @param AssetInterface[] $assets
     * @param array $tags
     * @param bool $unique
     * @param bool $prepend
     * @return $this
     */
    public function addMulti(array $assets, array $tags = [], $unique = false, $prepend = false)
    {
        foreach ($assets as $asset) {
            $this->add($asset, $tags, $unique, $prepend);
        }
        return $this;
    }

    /**
     * Ajoute un nouvel asset à la liste
     * @param AssetInterface $asset
     * @param array $tags
     * @param bool $unique
     * @param bool $prepend
     * @return \Move\Template\Html\Asset\AssetCollection|\Move\Utils\TaggedItemCollection
     */
    public function add($asset, array $tags = [], $unique = false, $prepend = false)
    {
        if (!$asset instanceof AssetInterface) {
            throw new \InvalidArgumentException('only assets can be added');
        }
        return parent::add($asset, $tags, $unique, $prepend);
    }

    /**
     * Renvoi la liste des asset dont TOUS les tags sont $tags
     * @param array $tags
     * @return AssetInterface[]
     */
    public function getByTags(array $tags)
    {
        return parent::getByTags($tags);
    }

    /**
     * Renvoi la liste des asset dont un tag est $tag
     * @param string $tag
     * @return AssetInterface[]
     */
    public function getByTag($tag)
    {
        return parent::getByTag($tag);
    }

    /**
     * @return AssetInterface[]
     */
    public function getAll()
    {
        return parent::getAll();
    }

    /**
     * Effectue un rendu de tous les assets via la strategy
     * @param string|array $tags
     * @return string
     */
    public function render($tags = [])
    {
        if (!\is_array($tags)) {
            $tags = [$tags];
        }
        return $this->strategy->render($this, $tags);
    }
}
