<?php

namespace Move\Advertiser\Google\DfpSmallBusiness;

use PHPUnit\Framework\TestCase;

/**
 * Class SizeMappingTest
 * @package Move\Advertiser\Google\DfpSmallBusiness
 */
class SizeMappingTest extends TestCase
{

    /**
     * @return array
     */
    public function sizeCollection() : array
    {
        return [
            new Size(1000, 200),
            new Size(1000, 90),
            new Size(970, 250),
            new Size(728, 90),
        ];
    }

    /**
     *
     */
    public function testConstruct()
    {
        $collection = $this->sizeCollection();

        $mapping = new SizeMapping('my_mapping', $collection);
        $this->assertSame('my_mapping', $mapping->name);
        $this->assertInternalType('array', $mapping->adSizeCollection);
        $this->assertCount(1, $mapping->adSizeCollection);
        $this->assertContains([new Size, $collection], $mapping->adSizeCollection);
        $this->assertCount(count($collection), $mapping->getUniqSizes());
        return $mapping;
    }

    /**
     *
     */
    public function testAppendSize()
    {
        $collection = $this->sizeCollection();
        $mapping = new SizeMapping('my_mapping', $collection);

        $adSize = new Size(300, 600);
        $mapping->appendAdSize($adSize, [$adSize]);

        $this->assertContains([$adSize, [$adSize]], $mapping->adSizeCollection);

        $this->assertCount(count($collection)+1, $mapping->getUniqSizes());
    }
}
