<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\ParserInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class TwitterTest
 * @package Move\Embed\AdapterProvider
 */
class TwitterTest extends TestCase
{
    /**
     * @return array
     */
    public function provideStrings()
    {
        $instance = new Twitter();
        $paprser = $instance->getParser();

        return [
            [$paprser, 'https://twitter.com/statuses/12354', true, '12354'],
            [$paprser, 'http://twitter.com/statuses/12355', true, '12355'],
            [$paprser, 'twitter.com/statuses/12356', true, '12356'],

            [$paprser, 'https://twitter.com/abcd/status/12357', true, '12357'],
            [$paprser, 'http://twitter.com/abcd/status/12358', true, '12358'],
            [$paprser, 'twitter.com/abcd/status/12359', true, '12359'],

            [$paprser, 'https://twitter.com/status/12360', false, '']
        ];
    }

    /**
     * @covers Twitter::getAdapter
     */
    public function testGetAdapter()
    {
        $instance = new Twitter();
        $this->assertInstanceOf(
            Oembed::class,
            $instance->getAdapter()
        );
    }

    /**
     * @covers Twitter::getParser
     */
    public function testGetParser()
    {
        $instance = new Twitter();
        $this->assertInstanceOf(
            ParserInterface::class,
            $instance->getParser()
        );
    }

    /**
     * @dataProvider provideStrings
     * @depends testGetParser
     * @param ParserInterface $parser
     * @param $string
     * @param $expectedResult
     * @param $expectedParam
     */
    public function testGetParserResult(ParserInterface $parser, $string, $expectedResult, $expectedParam)
    {
        $this->assertEquals($expectedResult, $parser->matchString($string, $param));
        if ($expectedResult) {
            $this->assertEquals($expectedParam, $param[1]);
        }
    }
}
