<?php

namespace Move\Http\Strategy\DataContainer;

use PHPUnit\Framework\TestCase;

/**
 * Class EngineDataContainerTest
 * @package Move\Http\Strategy\DataContainer
 */
class EngineDataContainerTest extends TestCase
{
    protected $dataset = [
        'data'=> [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    ];

    protected $template = [
        'idx1'=> [],
        'idx2'=> [],
        'idx3'=> []
    ];

    /**
     * @covers EngineDataContainer::__construct
     * @return EngineDataContainer
     */
    public function testConstruct()
    {
        $instance = new EngineDataContainer($this->template, $this->dataset);
        $this->assertInstanceOf(EngineDataContainer::class, $instance);
        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers EngineDataContainer::offsetExists
     * @param EngineDataContainer $container
     */
    public function testOffsetExists(EngineDataContainer $container)
    {
        $this->assertTrue($container->offsetExists('data'));
        $this->assertTrue($container->offsetExists('template'));

        $this->assertFalse($container->offsetExists('inexistant'));
    }

    /**
     * @depends testConstruct
     * @covers EngineDataContainer::offsetGet
     * @param EngineDataContainer $container
     * @return EngineDataContainer
     */
    public function testOffsetGetData(EngineDataContainer $container)
    {
        $container2 = new EngineDataContainer($this->template);
        $offest = 'data';

        $data = $container2->offsetGet($offest);
        $this->assertEmpty($data);

        $data = $container->offsetGet($offest);
        $this->assertNotEmpty($data);

        return $container;
    }

    /**
     * @depends testConstruct
     * @covers EngineDataContainer::offsetGet
     * @param EngineDataContainer $container
     * @return EngineDataContainer
     */
    public function testOffsetGetTemplate(EngineDataContainer $container)
    {
        $offest = 'template';

        $data = $container->offsetGet($offest);
        $this->assertEquals($this->template, $data);

        return $container;
    }

    /**
     * @depends testConstruct
     * @covers EngineDataContainer::offsetGet
     * @param EngineDataContainer $container
     * @return EngineDataContainer
     */
    public function testOffsetGetInexistantOffset(EngineDataContainer $container)
    {
        $this->assertNull($container->offsetGet('inexistant'));
    }

    /**
     * @depends testOffsetGetData
     * @covers EngineDataContainer::offsetSet
     */
    public function testOffsetSetData()
    {
        $container = new EngineDataContainer($this->template);
        $offest = 'data';
        $newData = range(10, 20);

        $container->offsetSet($offest, $newData);
        $this->assertEquals($newData, $container->offsetGet($offest));
    }

    /**
     * @depends testOffsetGetTemplate
     * @covers EngineDataContainer::offsetSet
     */
    public function testOffsetSetTemplate()
    {
        $container = new EngineDataContainer($this->template);
        $offest = 'template';
        $newData = 'lorem ipsum';

        $container->offsetSet($offest, $newData);
        $this->assertEquals($newData, $container->offsetGet($offest));
    }

    /**
     * @depends testOffsetGetData
     * @depends testOffsetGetTemplate
     * @covers EngineDataContainer::offsetSet
     */
    public function testOffsetSetInexistantOffest()
    {
        $data = ['a','b','c'];
        $container = new EngineDataContainer($this->template, $data);

        $container->offsetSet('inexistant', [1,2,3]);

        $this->assertEquals($data, $container->offsetGet('data'));

        $this->assertEquals(
            $this->template,
            $container->offsetGet('template')
        );
    }

    /**
     * @depends testConstruct
     * @covers EngineDataContainer::getTemplate
     * @param EngineDataContainer $container
     */
    public function testGetTemplate(EngineDataContainer $container)
    {
        $template = $container->getTemplate();
        $this->assertEquals($this->template, $template);
    }

    /**
     * @depends testConstruct
     * @depends testGetTemplate
     * @covers EngineDataContainer::setTemplate
     */
    public function testSetTemplate()
    {
        $template = ['idx' => 'value'];
        $container = new EngineDataContainer($this->template);

        $container->setTemplate($template);

        $this->assertEquals($template, $container->getTemplate());
    }

}
