<?php

namespace Move\Jato;

use GuzzleHttp\Client;
use Move\Http\Client\GuzzleClientAdapter;
use Move\Http\Client\HttpClientInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class JatoClientTest
 * @package Move\Jato
 */
class JatoClientTest extends TestCase
{
    /**
     * @return JatoClient
     */
    public function testConstruct() : JatoClient
    {
        $email = 'nlegall@movepublishing.com';
        $password = 'king7queen';

        $client = new JatoClient(
            new GuzzleClientAdapter(new Client(), 'webapi-live.jato.com/jato.carspecs.api'), $email,
            $password
        );

        $adapter = $client->getAdapter();
        $emailTest = $client->getEmail();
        $passwordTest = $client->getPassword();

        $this->assertInstanceOf(HttpClientInterface::class, $adapter, 'ClientAdapter error');
        $this->assertEquals($email, $emailTest, 'Email not equal');
        $this->assertEquals($password, $passwordTest, 'Password not equal');

        return $client;
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testSetLanguage(JatoClient $client)
    {
        $testLanguage = 5;
        $client->setLanguage($testLanguage);
        $language = $client->getLanguage();

        $this->assertEquals($language, $testLanguage, 'Language not set');
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testGetAdapter(JatoClient $client)
    {
        $result = $client->getAdapter();
        $this->assertInstanceOf(HttpClientInterface::class, $result, 'Error Adapter');
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testGetEmail(JatoClient $client)
    {
        $result = $client->getEmail();
        $test = filter_var($result, FILTER_VALIDATE_EMAIL);
        $this->assertInternalType('string', $test, 'Email not valid');
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testGetPassword(JatoClient $client)
    {
        $result = $client->getPassword();
        $this->assertInternalType('string', $result, 'Password not string');
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testGetToken(JatoClient $client)
    {
        $result = $client->getToken();
        $this->assertInternalType('string', $result, 'Token not a string');
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testGetLanguage(JatoClient $client)
    {
        $result = $client->getLanguage();
        $this->assertInternalType('int', $result, 'LanguageId not int');
    }

    /**
     * @depends testConstruct
     * @param JatoClient $client
     */
    public function testFetchListMake(JatoClient $client)
    {
        $path = 'makes/v2/load';
        $database = 'SSCF_CS2002';
        $params[] = ['databaseName' => $database];

        $result = $client->fetchList($path, [$params]);

        $this->assertInternalType('array', $result, 'Not an array');
        $this->assertNotEmpty($result, 'FetchList failed');
    }

}