<?php

namespace Cms\Client;

/**
 * Class AssetAwareModelTrait
 * @package Cms\Client
 * @property int $asset_id
 * @property \Cms\Model\Asset\AssetProfil $asset_profil
 * @property string $asset_credit
 * @property string $asset_mime
 * @property string $asset_filename
 * @property string $asset_legend
 * @property string $asset_ratio
 * @property string[] $asset_tags
 * @property \Cms\Model\Asset\Config\ConfigModel $asset_config
 */
trait AssetConfigAwareModelTrait
{

    /** @var  int */
    protected $asset_id;

    /** @var  \Cms\Model\Asset\AssetProfil */
    protected $asset_profil;

    /** @var  string */
    protected $asset_credit;

    /** @var  string */
    protected $asset_legend;

    /** @var  string[] */
    protected $asset_tags;

    /** @var  string */
    protected $asset_filename;

    /** @var  string */
    protected $asset_ratio;

    /** @var  string */
    protected $asset_mime;

    /** @var  \Cms\Model\Asset\Config\ConfigModel */
    protected $asset_config;
}
