<?php

namespace Cms\Client\Contract\Model;

use Cms\LinkResource\AbstractLinkResourceModel;
use Cms\LinkResource\FlattenResourcesAwareInterface;
use Cms\LinkResource\FlattenResourcesTrait;
use Cms\Model\Contract\Product\ProductModel;
use Cms\Model\Contract\Product\ProductResourceModel;

/**
 * Class ProductRestfulModel
 * @package Cms\Client\Contract\Model
 */
class ProductRestfulModel extends ProductModel implements
    FlattenResourcesAwareInterface
{
    use FlattenResourcesTrait;

    /**
     * @param AbstractLinkResourceModel|array $resourceData
     * @return AbstractLinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof ProductResourceModel) {
            $resourceData = (new ProductResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
