<?php


namespace Cms\LinkResource\Provider\CMS;

use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\AbstractDelegateDataAdapter;
use Cms\Model\AddressBook\Address\AddressModel;
use Cms\Model\AddressBook\AddressBookModel;
use Cms\Model\AddressBook\Trip\TripCategoryModel;
use Cms\Model\AddressBook\Trip\TripModel;
use POM\DomainObjectInterface;
use Psr\Cache\CacheItemPoolInterface;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

/**
 * Class AbstractCmsAddressBookProvider
 * @package Cms\LinkResource\Provider\CMS
 */
abstract class AbstractCmsAddressBookProvider extends AbstractDelegateDataAdapter implements
    CmsProviderScopeAwareInterface
{
    use CmsProviderScopeAwareTrait;

    /** @var array */
    protected $types = [
        LinkResourceType::ADDRESS_BOOK,
        LinkResourceType::ADDRESS_TRIP,
        LinkResourceType::ADDRESS_ADDRESS,
        LinkResourceType::ADDRESS_TRIP_CATEGORY,
    ];

    /**
     * AbstractCmsCampsiteProvider constructor.
     * @param \Psr\Cache\CacheItemPoolInterface|null $cachePool
     * @param \Psr\Log\LoggerInterface|null $logger
     */
    public function __construct(
        CacheItemPoolInterface $cachePool = null,
        LoggerInterface $logger = null
    ) {
        if ($cachePool !== null) {
            $this->setItemCachePool($cachePool);
        }
        $this->setLogger($logger ?: new NullLogger());
    }

    /**
     * @param \POM\DomainObjectInterface $model
     * @return null|string
     */
    protected function getLabelFromModel(DomainObjectInterface $model)
    {
        if ($model instanceof AddressModel) {
            $label = $model->city_name;
            if ($model->getAdmin2Code()) {
                $label .= ' (' . $model->getAdmin2Code() . ')';
            }
            $label .= ' > ' . $model->name;
            if (!empty($model->firm)) {
                $label .= ' (' . $model->firm . ')';
            }
            return $label;
        }
        if ($model instanceof AddressBookModel
            || $model instanceof TripModel
            || $model instanceof TripCategoryModel
        ) {
            return $model->name;
        }
        return null;
    }
}
