<?php


namespace Cms\LinkResource\Provider\CMS;

use Cms\Client\Geodata\Model\AdminRestfulModel;
use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\AbstractDelegateDataAdapter;
use Cms\Model\Geodata\AdminModel;
use Cms\Model\Geodata\CityModel;
use Cms\Model\Geodata\CountryModel;
use POM\DomainObjectInterface;

/**
 * Class AbstractCmsGeodataProvider
 * @package Cms\LinkResource\Provider\CMS
 */
abstract class AbstractCmsGeodataProvider extends AbstractDelegateDataAdapter
{

    /** @var array */
    protected $types = [
        LinkResourceType::GEO_ADMIN,
        LinkResourceType::GEO_CITY,
        LinkResourceType::GEO_COUNTRY,
    ];

    /**
     * @inheritdoc
     */
    public function getLabelFromModel(DomainObjectInterface $model)
    {
        if ($model instanceof AdminModel) {
            $label = $model->name;
            if ($model instanceof AdminRestfulModel) {
                if ($model->parent instanceof AdminModel) {
                    $label = $model->parent->name . ' > ' . $label;
                }
                return $model->country->nom_fr_fr . ' > ' . $label;
            }
            if ($model->parent_id) {
                $labelPrefix = $this->getLabel(
                    LinkResourceType::GEO_ADMIN,
                    $model->parent_id
                );
            } else {
                $labelPrefix = $this->getLabel(
                    LinkResourceType::GEO_COUNTRY,
                    $model->country_alpha2
                );
            }
            return $labelPrefix . ' > ' . $label;
        }
        if ($model instanceof CityModel) {
            $label = $model->name;
            if (!empty($model->admin1_code) || !empty($model->admin2_code)) {
                $labelPrefix = $this->getLabel(
                    LinkResourceType::GEO_ADMIN,
                    $model->admin1_code ?: $model->admin2_code
                );
                $label = $labelPrefix . ' > ' . $label;
            }
            return $label;
        }
        if ($model instanceof CountryModel) {
            return $model->nom_fr_fr;
        }
        return null;
    }
}
