<?php

namespace Cms\LinkResource\Provider\CMS;

use Cms\LinkResource\Provider\AbstractProviderDelegator;
use Cms\LinkResource\Provider\DelegateTypeAdapterInterface;

/**
 * Class CmsProvider
 * @package Cms\LinkResource\Provider\CMS
 */
class CmsProvider extends AbstractProviderDelegator implements CmsProviderScopeAwareInterface
{

    /* Identifier */
    public const IDENTIFIER = 'cms';

    /** @var string */
    protected $identifier = self::IDENTIFIER;

    /**
     * CmsProvider constructor.
     * @param DelegateTypeAdapterInterface[] $delegateTypes
     */
    public function __construct(array $delegateTypes = [])
    {
        foreach ($delegateTypes as $delegateType) {
            $this->delegate($delegateType);
        }
    }

    /**
     * @param int $scopeId
     * @return $this
     */
    public function setScopeId($scopeId)
    {
        $adapters = array_merge($this->searchAdapters, $this->dataAdapters);
        foreach ($adapters as $adapter) {
            if ($adapter instanceof CmsProviderScopeAwareInterface) {
                $adapter->setScopeId($scopeId);
            }
        }
        return $this;
    }
}
