<?php

namespace Cms\Model\Article;

use Cms\Specification\SlugSpecification;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class ArticleValidator
 * @package Cms\Model\Article
 */
class ArticleValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            'category_id' => true,
            'title' => true,
            'slug' => new SlugSpecification(),
            'profil' => new EnumSpecification(ArticleProfil::class),
            'state' => new EnumSpecification(ArticleState::class),
        ]);
        $myFilter->modify('state', function ($state) {
            return (string)$state;
        });
        $myFilter->modify('profil', function ($profil) {
            return (string)$profil;
        });

        return $myFilter;
    }
}
