<?php


namespace Cms\Search\Contract;

use Cms\Search\AbstractSearchClient;

/**
 * Class ContractSearchClient
 * @package Cms\Search\Contract
 */
class ContractSearchClient extends AbstractSearchClient
{

    /**
     * @var array
     */
    protected $sortCols = [
        'id',
        'modified_at',
        'created_at',
        'begin_at',
        'end_at',
        'state',
        'advertiser.advertiser_label.raw',
        'advertiser.addresses_nested.city_name.raw',
    ];

    /**
     * @return array
     */
    protected function getDefaultMatchFields() : array
    {
        return [];
    }

    /**
     * @return string
     */
    protected function getMappingType() : string
    {
        return ContractIndexFactory::MAPPING_NAME;
    }
}
