<?php

namespace Move\Command\Chain;

/**
 * Class AbstractHandler
 * @package Move\Command\Chain
 */
abstract class AbstractHandler implements HandlerInterface
{

    /**
     * @var HandlerInterface
     */
    private $successor = null;

    /**
     * Sets a successor handler,
     * in case the class is not able to satisfy the request.
     * @param HandlerInterface $handler
     */
    final public function setSuccessor(HandlerInterface $handler)
    {
        if ($this->successor === null) {
            $this->successor = $handler;
        } else {
            $this->successor->setSuccessor($handler);
        }
    }

    /**
     * Handles the request or redirect the request
     * to the successor, if the process response is null.
     * @param string|array $data
     * @return string
     */
    final public function handle($data)
    {
        $response = $this->process($data);
        if (($response === null) && ($this->successor !== null)) {
            $response = $this->successor->handle($data);
        }

        return $response;
    }

    /**
     * Processes the request.
     * This is the only method a child can implements,
     * with the constraint to return null to dispatch the request to next successor.
     * @param $request
     * @return null|mixed
     */
    abstract protected function process($request);
}
