<?php

namespace Move\Http\Strategy\Handler;

use GuzzleHttp\Psr7\Response;
use Move\Http\Strategy\Serializer\JsonSerializer;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class HtmlHandlerServiceTest
 * @package Move\Http\Strategy\Handler
 */
class HtmlHandlerServiceTest extends TestCase
{

    /**
     * @return array
     */
    public function provideIsSatisfiedBy()
    {
        return [
            ['text/html, application/html' ,true],
            ['application/json' ,false]
        ];
    }

    /**
     * @covers HtmlHandlerService::determineResponse
     */
    public function testDetermineResponse()
    {
        $expectedContentType = 'text/html';

        // Should use mock...
        $responseInterface = new Response();
        $service = new HtmlHandlerService(new JsonSerializer());

        $alteredService = $service->determineResponse(
            ['data'=>['head' => 'body']],
            $responseInterface
        );

        $this->assertInstanceOf(ResponseInterface::class, $alteredService);

        $contentType = $alteredService->getHeader('content-type');

        $this->assertArraySubset([$expectedContentType], $contentType);
    }

    /**
     * @covers HtmlHandlerService::isSatisfiedBy
     * @dataProvider provideIsSatisfiedBy
     * @param $returnValue
     * @param $expected
     */
    public function testIsSatisfiedBy($returnValue, $expected)
    {
        /** @var ServerRequestInterface $requeatInterface */
        $requeatInterface = $this->getMockBuilder(ServerRequestInterface::class)
            ->getMock();

        $requeatInterface->method('getHeaderLine')
            ->with('Accept')
            ->will($this->returnValue($returnValue));

        $service = new HtmlHandlerService(new JsonSerializer());

        $this->assertEquals($expected, $service->isSatisfiedBy($requeatInterface));
    }
}
