<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchAllBodyCommandTest
 * @package Move\Jato\Command
 */
class FetchAllBodyCommandTest extends TestCase
{
    /**
     * @return FetchAllBodyCommand
     */
    public function testConstruct() : FetchAllBodyCommand
    {
        $database = 'SSCF_CS2002';
        $makeKey = 'Aston Martin';
        $modelKey = 'DB11';
        $modelYear = '2017';
        $command = new FetchAllBodyCommand($database, $makeKey, $modelKey, $modelYear);

        $databaseTest = $command->getDatabase();
        $makeKeyTest = $command->getMakeKey();
        $modelKeyTest = $command->getModelKey();
        $modelYearTest = $command->getModelYear();

        $this->assertEquals($database, $databaseTest, 'Database not equal');
        $this->assertEquals($makeKey, $makeKeyTest, 'MakeKey not equal');
        $this->assertEquals($modelKey, $modelKeyTest, 'ModelKey not equal');
        $this->assertEquals($modelYear, $modelYearTest, 'ModelYear not equal');

        return $command;
    }

    /**
     * @depends testConstruct
     * @param FetchAllBodyCommand $command
     */
    public function testGetMakeKey(FetchAllBodyCommand $command)
    {
        $result = $command->getMakeKey();
        $this->assertInternalType('string', $result, 'MakeKey not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllBodyCommand $command
     */
    public function testGetModelKey(FetchAllBodyCommand $command)
    {
        $result = $command->getModelKey();
        $this->assertInternalType('string', $result, 'ModelKey not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllBodyCommand $command
     */
    public function testGetModelYear(FetchAllBodyCommand $command)
    {
        $result = $command->getModelYear();
        $this->assertInternalType('string', $result, 'ModelYear not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllBodyCommand $command
     */
    public function testSetMakeKey(FetchAllBodyCommand $command)
    {
        $new = 'test';
        $command->setMakeKey($new);
        $result = $command->getMakeKey();

        $this->assertEquals($new, $result, 'MakeKey not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllBodyCommand $command
     */
    public function testSetModelKey(FetchAllBodyCommand $command)
    {
        $new = 'test';
        $command->setModelKey($new);
        $result = $command->getModelKey();

        $this->assertEquals($new, $result, 'ModelKey not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllBodyCommand $command
     */
    public function testSetModelYear(FetchAllBodyCommand $command)
    {
        $new = 'test';
        $command->setModelYear($new);
        $result = $command->getModelYear();

        $this->assertEquals($new, $result, 'ModelYear not set');
    }

}