<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\PubRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class PubClient
 * @package Cms\Client\Campsite
 */
class PubClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite/pub';

    /**
     * @param array $dataset
     * @return PubRestfulModel
     */
    public function handleData($dataset = []) : Model\PubRestfulModel
    {
        return (new PubRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|PubRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
