<?php


namespace Cms\Client\Service;

use Cms\Client\Geodata\AdminClient;
use Cms\Client\Geodata\CityClient;
use Cms\Client\Geodata\CountryClient;
use Cms\Client\Geodata\DivisionClient;
use Move\Command\CommandBusInterface;

/**
 * Class GeodataService
 * @package Cms\Client\Service
 */
class GeodataService
{

    /** @var AdminClient */
    private $adminClient;

    /** @var CityClient */
    private $cityClient;

    /** @var CountryClient */
    private $countryClient;

    /** @var CommandBusInterface */
    private $commandBus;

    /** @var DivisionClient */
    private $divisionClient;


    /**
     * GeodataService constructor.
     * @param AdminClient $adminClient
     * @param CityClient $cityClient
     * @param CountryClient $countryClient
     * @param DivisionClient $divisionClient
     * @param CommandBusInterface $commandBus
     */
    public function __construct(
        AdminClient $adminClient,
        CityClient $cityClient,
        CountryClient $countryClient,
        DivisionClient $divisionClient,
        CommandBusInterface $commandBus
    ) {
        $this->adminClient = $adminClient;
        $this->cityClient = $cityClient;
        $this->countryClient = $countryClient;
        $this->divisionClient = $divisionClient;
        $this->commandBus = $commandBus;
    }


    /**
     * @return AdminClient
     */
    public function getAdminClient()
    {
        return $this->adminClient;
    }

    /**
     * @param AdminClient $adminClient
     * @return $this
     */
    public function setAdminClient(AdminClient $adminClient)
    {
        $this->adminClient = $adminClient;
        return $this;
    }

    /**
     * @return CityClient
     */
    public function getCityClient()
    {
        return $this->cityClient;
    }

    /**
     * @param CityClient $cityClient
     * @return $this
     */
    public function setCityClient(CityClient $cityClient)
    {
        $this->cityClient = $cityClient;
        return $this;
    }

    /**
     * @return CountryClient
     */
    public function getCountryClient()
    {
        return $this->countryClient;
    }

    /**
     * @param CountryClient $countryClient
     * @return $this
     */
    public function setCountryClient(CountryClient $countryClient)
    {
        $this->countryClient = $countryClient;
        return $this;
    }

    /**
     * @return CommandBusInterface
     */
    public function getCommandBus()
    {
        return $this->commandBus;
    }

    /**
     * @param CommandBusInterface $commandBus
     * @return $this
     */
    public function setCommandBus(CommandBusInterface $commandBus)
    {
        $this->commandBus = $commandBus;
        return $this;
    }

    /**
     * @return DivisionClient
     */
    public function getDivisionClient() : DivisionClient
    {
        return $this->divisionClient;
    }

    /**
     * @param DivisionClient $divisionClient
     * @return $this
     */
    public function setDivisionClient(DivisionClient $divisionClient)
    {
        $this->divisionClient = $divisionClient;
        return $this;
    }
}
