<?php

namespace Cms\LinkResource\Provider;

use Cms\Client\AbstractClient;
use POM\DomainObjectInterface;

/**
 * Class CmsRestfulClientAdapter
 * @package Cms\LinkResource\Provider
 */
class ProviderRestfulClientAdapter implements ProviderClientAdapterInterface
{

    /** @var \Cms\Client\AbstractClient */
    private $client;

    /**
     * CmsRestfulClientAdapter constructor.
     * @param \Cms\Client\AbstractClient $client
     */
    public function __construct(AbstractClient $client)
    {
        $this->client = $client;
    }

    /**
     * @param mixed $objectId
     * @return \POM\DomainObjectInterface
     * @throws \RuntimeException
     */
    public function fetchModel($objectId) : DomainObjectInterface
    {
        try {
            $object = $this->client->fetchItem($objectId);
            if ($object instanceof DomainObjectInterface) {
                return $object;
            }
        } catch (\Exception $e) {
        }
        throw new \RuntimeException('object cannot be retrieve with client', null, $e ?? null);
    }
}
