<?php


namespace Move\Advertiser\Google\DfpSmallBusiness;

/**
 * Class Slot
 * @package Move\Advertiser\Google\DfpSmallBusiness
 */
class Slot
{

    /** @var \Move\Advertiser\Google\DfpSmallBusiness\Size[]|null */
    public $sizes;

    /** @var string|null */
    public $divId;

    /** @var \Move\Advertiser\Google\DfpSmallBusiness\SizeMapping|null */
    public $sizeMapping;

    /** @var array */
    public $targeting;

    /**
     * Slot constructor.
     * @param string|null $divId
     * @param \Move\Advertiser\Google\DfpSmallBusiness\Size[]|null $sizes
     */
    public function __construct(string $divId = null, array $sizes = null)
    {
        $this->divId = $divId;
        if ($sizes !== null) {
            $this->sizes = array_values($sizes);
        }
        $this->targeting = [];
    }

    /**
     * @param \Move\Advertiser\Google\DfpSmallBusiness\SizeMapping $mapping
     * @return $this
     */
    public function setSizeMapping(SizeMapping $mapping) : self
    {
        $this->sizeMapping = $mapping;
        return $this;
    }

    /**
     * @param string $name
     * @param string|array $value
     * @return $this
     */
    public function setTargeting(string $name, $value) : self
    {
        $this->targeting[$name] = $value;
        return $this;
    }
}
