<?php


namespace Move\Command;

use League\Tactician\CommandBus;

/**
 * Class TactitianBusAdapter
 * @package Move\Command
 */
class TactitianBusAdapter implements CommandBusInterface
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * TactitianBusAdapter constructor.
     * @param CommandBus $commandBus
     */
    public function __construct(CommandBus $commandBus)
    {
        $this->commandBus = $commandBus;
    }

    /**
     * @param object $command
     * @return mixed
     */
    public function handle($command)
    {
        return $this->commandBus->handle($command);
    }
}
