<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\AdapterInterface;
use Move\Embed\Adapter\GenericIframe;
use Move\Embed\Parser\ParserInterface;
use Move\Embed\Parser\RegexParser;

/**
 * Class FallbackAdapter
 * @package Move\Embed\AdapterProvider
 */
class FallbackAdapter extends AbstractAdapterProvider
{

    /**
     * @return AdapterInterface
     * @internal param array $uriParams
     */
    public function getAdapter()
    {
        return new GenericIframe();
    }

    /**
     * @return ParserInterface
     */
    public function getParser()
    {
        return new RegexParser('@^(?:https?://)?.*$@');
    }
}
