<?php


namespace Move\Template\Extensions;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class Weborama
 * @package Move\Template\Extensions
 */
class Weborama implements ExtensionInterface
{

    /** @var \Move\Template\Html\Asset\Weborama */
    private $weborama;

    /**
     * Weborama constructor.
     * @param \Move\Template\Html\Asset\Weborama $weborama
     */
    public function __construct(\Move\Template\Html\Asset\Weborama $weborama = null)
    {
        $this->weborama = $weborama;
    }

    /**
     * @param \League\Plates\Engine $engine
     */
    public function register(Engine $engine)
    {
        if ($this->weborama) {
            $engine->registerFunction('wam_setup', [$this->weborama, '__toString']);
        }
        $engine->registerFunction('wam_sendevent', [$this, 'runEventSend']);
        $engine->registerFunction('wam_senduserid', [$this, 'runSendUserId']);
    }

    /**
     * @param string $eventKey
     * @param string $eventValue
     * @return string
     */
    public function runEventSend(string $eventKey, string $eventValue) : string
    {
        return <<<EOF
<script>window.wamf && window.wamf.eventSend('2', '$eventKey', '$eventValue')</script>
EOF;
    }

    /**
     * @param string $userId
     * @return string
     */
    public function runSendUserId(string $userId) : string
    {
        return $this->runEventSend('userid', $userId);
    }
}
