<?php


namespace Cms\Client\Service;

/**
 * Trait AssetServiceAwareTrait
 * @package Cms\Client\Service
 */
trait AssetServiceAwareTrait
{

    /** @var  \Cms\Client\Service\AssetService */
    protected $assetService;

    /**
     * @param \Cms\Client\Service\AssetService $assetService
     * @return $this
     */
    public function setAssetService(AssetService $assetService)
    {
        $this->assetService = $assetService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\AssetService
     * @throws \DomainException
     */
    public function getAssetService() : AssetService
    {
        if (!$this->assetService instanceof AssetService) {
            throw new \DomainException('assetService is not a AssetService instance');
        }
        return $this->assetService;
    }
}
