<?php


namespace Cms\Client\Service;

/**
 * Trait CmsStatsServiceAwareTrait
 * @package Cms\Client\Service
 */
trait CmsStatsServiceAwareTrait
{
    /** @var  \Cms\Client\Service\CmsStatsService */
    protected $cmsStatsService;

    /**
     * @param \Cms\Client\Service\CmsStatsService $cmsStatsService
     * @return $this
     */
    public function setCmsStatsService(CmsStatsService $cmsStatsService)
    {
        $this->cmsStatsService = $cmsStatsService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\CmsStatsService
     * @throws \DomainException
     */
    public function getCmsStatsService() : CmsStatsService
    {
        if (!$this->cmsStatsService instanceof CmsStatsService) {
            throw new \DomainException('cmsStatsService is not a CmsStatsService instance');
        }
        return $this->cmsStatsService;
    }
}
