<?php


namespace Cms\Client\Service;

/**
 * Trait VersionServiceAwareTrait
 * @package Cms\Client\Service
 */
trait VersionServiceAwareTrait
{

    /** @var  \Cms\Client\Service\VersionService */
    protected $versionService;

    /**
     * @param \Cms\Client\Service\VersionService $versionService
     * @return $this
     */
    public function setVersionService(VersionService $versionService)
    {
        $this->versionService = $versionService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\VersionService
     * @throws \DomainException
     */
    public function getVersionService() : VersionService
    {
        if (!$this->versionService instanceof VersionService) {
            throw new \DomainException('versionService is not a VersionService instance');
        }
        return $this->versionService;
    }
}
