<?php


namespace Cms\Extension\TemplateBloc\Decorator;

/**
 * Class DecoratorHandler
 * @package Cms\Extension\TemplateBloc\Decorator
 */
class DecoratorHandler
{

    /** @var TemplateBlocDecoratorInterface[] */
    private $blocDecorators;

    /**
     * @param TemplateBlocDecoratorInterface $decorator
     * @return $this
     */
    public function addBlocDecorator(TemplateBlocDecoratorInterface $decorator)
    {
        $this->blocDecorators[] = $decorator;
        return $this;
    }

    /**
     * @param mixed $templateBloc
     * @param mixed $command
     * @return mixed
     */
    public function handleBloc($templateBloc, $command)
    {
        foreach ($this->blocDecorators as $decorator) {
            $decorator->decorate($templateBloc, $command);
        }
        return $command;
    }
}
