<?php


namespace Cms\LinkResource;

/**
 * Interface FlattenResourcesAwareInterface
 * @package Cms\LinkResource
 */
interface FlattenResourcesAwareInterface
{

    /**
     * @param LinkResourceType|string $resourceType
     * @param null|string $prefName
     * @param null|string $prefValue
     * @return LinkResourceModel[]
     */
    public function getResourceByType($resourceType, $prefName = null, $prefValue = null);

    /**
     * @param LinkResourceModel $model
     * @return $this
     */
    public function addInResourceTree(LinkResourceModel $model);

    /**
     * @param \Cms\LinkResource\LinkResourceModel $resourceModel
     * @return $this
     */
    public function removeInResourceTree(LinkResourceModel $resourceModel);

    /**
     * @param LinkResourceType|string $resourceType
     * @param string $resourceRef
     * @param string $resourceProvider
     * @param array $otherProps
     * @return LinkResourceModel
     */
    public function addResourceType(
        $resourceType,
        $resourceRef,
        $resourceProvider,
        array $otherProps = []
    );

    /**
     * @param LinkResourceModel $resourceModel
     * @return bool
     */
    public function hasResource(LinkResourceModel $resourceModel) : bool;

    /**
     * @return AbstractLinkResourceModel[]
     */
    public function getFlattenResources();

    /**
     * @return array
     */
    public function getResourceTree() : array;
}
