<?php

namespace Move\Http\Strategy\Serializer;

use Psr\Http\Message\ResponseInterface;

/**
 * Interface SerializerInterface
 * @package Move\Http\Strategy\Serializer
 */
interface SerializerInterface
{

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return string
     */
    public function serialize($dataset, ResponseInterface $response);

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return string
     */
    public function __invoke($dataset, ResponseInterface $response);
}
