<?php

namespace Move\Template;

use League\Plates\Engine;
use RuntimeException;

/**
 * Class EngineAwareTrait
 * @package Move\Template
 */
trait EngineAwareTrait
{

    /**
     * @var \League\Plates\Engine
     */
    protected $engine;

    /**
     * Return the engine object.
     * @throws \RuntimeException if an engine object cannot be determined
     * @return \League\Plates\Engine
     */
    public function getEngine()
    {
        if (null !== $this->engine) {
            return $this->engine;
        }

        throw new RuntimeException('Unable to determine an engine object');
    }

    /**
     * Set Engine object.
     * @param \League\Plates\Engine $engine
     * @return $this
     */
    public function setEngine(Engine $engine)
    {
        $this->engine = $engine;

        return $this;
    }
}
