<?php


namespace Move\Embed\Normalizer;

use Move\Embed\Parser\RegexParser;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class YoutubeNormalizerTest
 * @package Move\Embed\Normalizer
 */
class YoutubeNormalizerTest extends TestCase
{
    public static function provideNormalizeStr()
    {
        $url = 'https://www.youtube.com/watch?v=';
        return [
            ['/ytb([0-9]+)/', 'ytb123', $url .'123'],
            ['/ytb([0-9]+)/', 'aaa123', 'aaa123'],
        ];
    }

    /**
     * @covers YoutubeNormalizer::__construct
     */
    public function testConstruct()
    {
        $parser = new RegexParser('/[0-9]+/');
        $instance = new YoutubeNormalizer($parser);

        $this->assertInstanceOf(YoutubeNormalizer::class, $instance);

        $this->assertEquals(
            $parser,
            Reflection::getValue($instance, 'parser')
        );
    }

    /**
     * @depends testConstruct
     * @dataProvider provideNormalizeStr
     * @covers YoutubeNormalizer::normalizeStr
     * @param $regex
     * @param $str
     * @param $expected
     */
    public function testNormalizeStr($regex, $str, $expected)
    {
        $parser = new RegexParser($regex);
        $instance = new YoutubeNormalizer($parser);
        $this->assertEquals($expected, $instance->normalizeStr($str));
    }

    /**
     * @depends testConstruct
     * @covers YoutubeNormalizer::__invoke
     * @dataProvider provideNormalizeStr
     * @param $regex
     * @param $str
     * @param $expected
     */
    public function testInvoke($regex, $str, $expected)
    {
        $parser = new RegexParser($regex);
        $instance = new YoutubeNormalizer($parser);
        $this->assertEquals($expected, $instance($str));
    }
}
