<?php

namespace Move\Http\Route;

use PHPUnit\Framework\TestCase;

/**
 * Class AbstractRouteProviderTest
 * @package Move\Http\Route
 */
class AbstractRouteProviderTest extends TestCase
{

    /**
     * @covers RouterAdapterInterface::setRouterAdapter
     */
    public function testSetRouterAdapter()
    {
        /** @var AbstractRouteProvider $instance */
        $instance = $this->getMockForAbstractClass(AbstractRouteProvider::class);

        /** @var RouterAdapterInterface $mockRoute */
        $mockRoute = $this->getMockBuilder(RouterAdapterInterface::class)
            ->getMock();

        $result = $instance->setRouterAdapter($mockRoute);
        $this->assertSame($instance, $result);
    }
}
