<?php

namespace Move\Http\Route;

use League\Container\ContainerInterface;
use PHPUnit\Framework\TestCase;

class AbstractRouterAdapterTest extends TestCase
{

    /**
     * @covers AbstractRouterAdapter::delegate
     */
    public function testDelegate()
    {
        /** @var AbstractRouterAdapter $instance */
        $instance = $this->getMockForAbstractClass(AbstractRouterAdapter::class);

        /** @var AbstractRouteProvider $routeProvider */
        $routeProvider = $this->getMockForAbstractClass(AbstractRouteProvider::class);

        /** @var ContainerInterface $containerInterface */
        $containerInterface = $this->getMockBuilder(ContainerInterface::class)
            ->getMock();

        $instance->delegate([$routeProvider], $containerInterface);
    }

    /**
     * @covers AbstractRouterAdapter::delegate
     * @expectedException  \InvalidArgumentException
     */
    public function testDelegateThrowsInvalidArgumentException()
    {
        /** @var AbstractRouterAdapter $instance */
        $instance = $this->getMockForAbstractClass(AbstractRouterAdapter::class);

        /** @var ContainerInterface $containerInterface */
        $containerInterface = $this->getMockBuilder(ContainerInterface::class)
            ->getMock();

        $instance->delegate(['DummyProvider'], $containerInterface);
    }
}
